capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Econometric analysis"
set more off
set maxiter 300

**** SET PERIOD ***
local perd "long"      // can be "long" or "short"

log using Outputs/log/anOpexReg25-`perd', replace text

putdocx begin
putdocx paragraph, style(Title)
putdocx text ("DNSP 2025 Opex Cost Function - `perd' period" )


display "Models: `perd'"

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function
Author:  Michael Cunningham (based on a Denis Lawrence program)
		 with modifications by Joe Hirschberg & Alice Giovani
File:    anOpexReg25.do
Initial Date:    4-Jul-2022
Revised Date:	10-Jul-2025

--------------------------------------------------------------------------*/
tempfile data data1

* Period & dependent variable
if "`perd'" == "long" {
	local startyr 2006
	}
else if "`perd'" == "short" {
	local startyr 2012
}
local endyr   2024

* 
scalar define ppp_aust   		   = 1.527404363
scalar define ppp_nz    		   = 1.482877481
scalar define ppp_canada		   = 1.249076963

scalar define propex_rebase_aust   = 1.238501756
scalar define propex_rebase_nz     = 1.221665248
scalar define propex_rebase_canada = 1.160123933
									 


* Read data
use Input/DNSPopex25.dta, clear
xtset eiid year

gen int dnsp = eiid - 1000 if country == 1
qui tabulate dnsp, gen(d)
forvalues k = 1/13 {
	replace d`k' = 0 if d`k' == .
}

tabulate country, gen(jur)
correlate custnum circlen rmdem shareugc
tabulate year

summarize d* jur*

* Sample selection
*-------------------------
drop if country == 3 & year < (`startyr' - 1)
drop if country < 3 & year < `startyr'
drop if country == 3 & year > (`endyr' - 1)
drop if country < 3 & year > `endyr'

* Modify & create variables
*--------------------------
* Adressing change of VIC's DNSP from calendar to financial year in 2021

generate yr=year
replace yr=yr+0.5 if dnsp==3 & year<2021
replace yr=yr+0.5 if dnsp==8 & year<2021
replace yr=yr+0.5 if dnsp==9 & year<2021
replace yr=yr+0.5 if dnsp==11 & year<2021
replace yr=yr+0.5 if dnsp==13 & year<2021
replace yr=yr-0.25 if country==2
replace yr=yr+0.5 if country==3

replace propex = propex / propex_rebase_aust    if country==1
replace propex = propex / propex_rebase_nz      if country==2
replace propex = propex / propex_rebase_canada  if country==3
replace propex = propex * ppp_nz / ppp_aust     if country==2
replace propex = propex * ppp_canada / ppp_aust if country==3

*gen lastob = 0
*replace lastob = 1 if dnsp != dnsp[_n+1]

* Regression log variables

gen lvc = log(opex / propex)
gen ly1 = log(custnum)
gen ly2 = log(circlen)
gen ly3 = log(rmdem)
gen lz1 = log(shareugc)

* mean correct output data

qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3

* TLG variables

gen ly11 = (ly1^2)/2
gen ly12 = ly1*ly2
gen ly13 = ly1*ly3
gen ly22 = (ly2^2)/2
gen ly23 = ly2*ly3
gen ly33 = (ly3^2)/2

* Labels

label variable ly1  "ln(Custnum)=x1" 
label variable ly2  "ln(CircLen)=x2" 
label variable ly3  "ln(RMDemand)=x3" 
label variable lz1  "ln(ShareUGC)" 
label variable ly11 "x1*x1/2" 
label variable ly12 "x1*x2" 
label variable ly13 "x1*x3" 
label variable ly22 "x2*x2/2" 
label variable ly23 "x2*x3" 
label variable ly33 "x3*x3/2"
label variable yr   "Year" 
label variable jur2 "New Zealand" 
label variable jur3 "Ontario" 
label variable d2   "AGD" 
label variable d3   "CIT" 
label variable d4   "END" 
label variable d5   "ENX" 
label variable d6   "ERG"
label variable d7   "ESS" 
label variable d8   "JEN" 
label variable d9   "PCR" 
label variable d10  "SAP"
label variable d11  "AND" 
label variable d12  "TND" 
label variable d13  "UED"

* Regression models
*---------------------- 

*================================
* 1. LSECD
*================================

xtpcse lvc ly1 ly2 ly3 lz1 yr jur2 jur3 d2-d13, c(a) het
estimates store LSECD

*EFFICIENCY SCORES

predictnl eff1 = exp(min(0,(_b[d2]),(_b[d3]),(_b[d4]),(_b[d5]),(_b[d6]), /// 
    (_b[d7]),(_b[d8]),(_b[d9]),(_b[d10]),(_b[d11]),(_b[d12]),(_b[d13]))), ///
	 ci(eff1_lb  eff1_ub)
	 
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1
		
forvalues i = 2/13 {
  predictnl eff`i' = exp(min(0,(_b[d2]),(_b[d3]),(_b[d4]),(_b[d5]),(_b[d6]), /// 
    (_b[d7]),(_b[d8]),(_b[d9]),(_b[d10]),(_b[d11]),(_b[d12]),(_b[d13]))-(_b[d`i'])), ///
	 ci(eff`i'_lb  eff`i'_ub)
   
  replace eff    = eff`i'    if dnsp == `i'
  replace eff_lb = eff`i'_lb if dnsp == `i'
  replace eff_ub = eff`i'_ub if dnsp == `i'		
}

forval i = 1/13 {
    drop eff`i' eff`i'_lb eff`i'_ub
} 

putdocx paragraph, style(Subtitle)
putdocx text ("LSECD `perd' Efficiency Scores")

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD", replace)
putdocx collect

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A8)
putdocx collect

* OUTPUT ELASTICITIES	

predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

* Tabulation

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A46)	

putdocx paragraph, style(Subtitle)
putdocx text ("LSECD `perd' Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect


* STATS TESTS
predict fit, xb
gen e2 = (lvc - fit)^2
summarize e2
scalar define see = sqrt(r(mean))
scalar list see
gen stude = (lvc - fit)/see
iqr stude
swilk stude

scalar k_lsecd = 20 
qui corr lvc fit
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_lsecd))	
display "LSECD Pseudo-adjusted R2 = " `psadjr2'

	
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff eff_lb eff_ub fit e2 stude


*================================
* 2. LSETLG
*================================

xtpcse lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3 ///
	d2-d13, c(a) het
estimates store LSETLG

*EFFICIENCY SCORES

predictnl eff1 = exp(min(0,(_b[d2]),(_b[d3]),(_b[d4]),(_b[d5]),(_b[d6]), /// 
    (_b[d7]),(_b[d8]),(_b[d9]),(_b[d10]),(_b[d11]),(_b[d12]),(_b[d13]))), ///
	 ci(eff1_lb  eff1_ub)
	 
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1
		
forvalues i = 2/13 {
  predictnl eff`i' = exp(min(0,(_b[d2]),(_b[d3]),(_b[d4]),(_b[d5]),(_b[d6]), /// 
    (_b[d7]),(_b[d8]),(_b[d9]),(_b[d10]),(_b[d11]),(_b[d12]),(_b[d13]))-(_b[d`i'])), ///
	 ci(eff`i'_lb  eff`i'_ub)
   
  replace eff    = eff`i'    if dnsp == `i'
  replace eff_lb = eff`i'_lb if dnsp == `i'
  replace eff_ub = eff`i'_ub if dnsp == `i'		
}

forval i = 1/13 {
    drop eff`i' eff`i'_lb eff`i'_ub
} 

putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG `perd' Efficiency Scores")

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG", replace)
putdocx collect

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A8)
putdocx collect


* OUTPUT ELASTICITIES	
	
predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1) p(p1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2) p(p2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3) p(p3)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A46)

table (dnsp) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A53)
	
table (dnsp) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A70)
	
table (dnsp) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A87)

putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG `perd' Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect
	
display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,1,0)	
replace mon2 = cond(ely2 < 0,1,0)	
replace mon3 = cond(ely3 < 0,1,0)
replace montot = 1 if mon1 == 1 | mon2 == 1 | mon3 == 1

putdocx paragraph, style(Subtitle)
putdocx text ("LSETLG `perd'  Monotonicity Violations")
table (country) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.3f)
putdocx collect

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ///
	using Outputs/xlsx/monotonicity-`perd'.xlsx, ///
	sheet("LSETLG", replace) firstrow(var) 	
	

* STATS TESTS
test ly11 ly12 ly13 ly22 ly23 ly33

predict fit, xb
gen e2 = (lvc - fit)^2
summarize e2
scalar define see = sqrt(r(mean))
scalar list see
gen stude = (lvc - fit)/see
iqr stude
swilk stude

scalar k_lsecd = 26
qui corr lvc fit
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_lsecd))	
display "LSETLG Pseudo-adjusted R2 = " `psadjr2'

	
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff eff_lb eff_ub mon1 mon2 mon3 montot e2 stude p1 p2 p3 fit

	
*================================
* 3. SFACD
*================================

qui reg lvc ly1 ly2 ly3 lz1 yr jur2 jur3
matrix b0 = e(b), ln(e(rmse)^2) , .1, .1
xtfrontier lvc ly1 ly2 ly3 lz1 yr jur2 jur3, cost from(b0, copy) ti diff 
estimates store SFACD

*EFFICIENCY SCORES

predict tec, te
frontier_teci tec
generate eff = 1/tec
generate eff_lb = 1/tec_u
generate eff_ub = 1/tec_l

putdocx paragraph, style(Subtitle)
putdocx text ("SFACD `perd' Efficiency Scores")
	
table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD", replace)
putdocx collect

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A8)

putdocx collect


* OUTPUT ELASTICITIES	

predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A46)	
		
putdocx paragraph, style(Subtitle)
putdocx text ("SFACD `perd' Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect

* STATS TESTS
predict yhat1, xb
predict yhat2, u
gen yhat = yhat1 + yhat2	
gen eh = lvc - yhat
estat ic

scalar k_sfacd = 11		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFACD Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh


drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	 eff eff_lb eff_ub tec tec_u tec_l yhat eh

*================================
* 4. SFATLG
*================================

qui reg lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3
matrix b0 = e(b) 
matrix b0 = e(b), ln(e(rmse)^2) , .1, .1
xtfrontier lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3, ///
	cost from(b0, copy) ti diff iter(2000)
estimates store SFATLG

*EFFICIENCY SCORES

predict tec, te
frontier_teci tec
generate eff = 1/tec
generate eff_lb = 1/tec_u
generate eff_ub = 1/tec_l

putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG `perd' Efficiency Scores")

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG", replace)
putdocx collect

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A8)
putdocx collect

* OUTPUT ELASTICITIES	

predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1) p(p1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2) p(p2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3) p(p3)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A46)	
	
	table (dnsp) (var), stat(mean ely1 lw_y1 up_y1)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A53)
	
table (dnsp) (var), stat(mean ely2 lw_y2 up_y2)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A70)
	
table (dnsp) (var), stat(mean ely3 lw_y3 up_y3)
collect export Outputs/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A87)

putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG `perd' Elasticities")
table (country) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean ely1 ely2 ely3 elY) nformat(%5.3f)
putdocx collect

display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,1,0)	
replace mon2 = cond(ely2 < 0,1,0)	
replace mon3 = cond(ely3 < 0,1,0)
replace montot = 1 if mon1 == 1 | mon2 == 1 | mon3 == 1

putdocx paragraph, style(Subtitle)
putdocx text ("SFATLG `perd' Monotonicity Violations")
table (country) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.3f)
putdocx collect
table (dnsp) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.3f)
putdocx collect

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ///
    using Outputs/xlsx/monotonicity-`perd'.xlsx, ///
	sheet("SFATLG", replace) firstrow(var)

* STATS TESTS

test ly11 ly12 ly13 ly22 ly23 ly33

predict fit0, xb
predict fit1, u
gen yhat = fit0 + fit1
gen eh = lvc - fit0
estat ic

gen v2 = (lvc - fit0 - fit1)^2
summarize v2
scalar define sev = sqrt(r(mean))
scalar list sev
gen studv = (lvc - fit0 - fit1)/sev
iqr studv
swilk studv

scalar k_sfatlg = 17 		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFATLG Pseudo-adjusted R2 = " `psadjr2'

	
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff eff_lb eff_ub mon1 mon2 mon3 montot v2 p1 p2 p3 fit0 fit1
*******

* LR test
lrtest SFATLG SFACD


* Tabulating models
*--------------------

estout LSECD using Outputs/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("LSECD-`perd'") stats(r2 N, fmt(3)) replace
estout LSETLG using Outputs/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("LSETLG-`perd'") stats(r2 N, fmt(3)) append
estout SFACD using Outputs/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("SFACD-`perd'") stats(r2 N, fmt(3)) append
estout SFATLG using Outputs/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("SFATLG-`perd'") stats(r2 N, fmt(3)) append

drop _est_LSECD	_est_LSETLG	_est_SFACD	_est_SFATLG	
	
export excel using Outputs/xlsx/outputdata-`perd'.xlsx ///
	if eiid < 2000, firstrow(var) replace

putdocx save Outputs/docx/DNSP_2025-`perd', replace

***

log close
exit
